package com.tandbergtv.watchpoint.studio.external.jpf.model;

/**
 * Entity class for Resource Group Plugin Extension.
 * 
 * @author Raj Prakash
 */
public class ResourceGroupDescriptor implements WatchPointDescriptor
{
	private static final long serialVersionUID = 1L;

	private String pluginId;

	private String extensionId;

	private String name;
	
	private String path;

	private String description;

	private String systemId;

	private String functionalType;
	
	private String accessLevel;
	
	private Boolean isInternallyAcquired; 
	
	private String imagePath;

	private String allocationStrategyClass;
	
	private ClassLoader classLoader;
	
	private int version;

	/**
	 * @return the classloader
	 */
	public ClassLoader getClassLoader()
	{
		return this.classLoader;
	}

	/**
	 * @param classLoader
	 *            the classloader to set
	 */
	public void setClassLoader(ClassLoader classLoader)
	{
		this.classLoader = classLoader;
	}

	/**
	 * @return the imagePath
	 */
	public String getImagePath() {
		return imagePath;
	}

	/**
	 * @param imagePath the imagePath to set
	 */
	public void setImagePath(String imagePath) {
		this.imagePath = imagePath;
	}

	/**
	 * @return the description
	 */
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the systemId
	 */
	public String getSystemId()
	{
		return this.systemId;
	}

	/**
	 * @param systemId
	 *            the systemId to set
	 */
	public void setSystemId(String systemId)
	{
		this.systemId = systemId;
	}

	/**
	 * @return the extensionId
	 */
	public String getExtensionId()
	{
		return this.extensionId;
	}

	/**
	 * @param extensionId
	 *            the extensionId to set
	 */
	public void setExtensionId(String extensionId)
	{
		this.extensionId = extensionId;
	}

	/**
	 * @return the pluginId
	 */
	public String getPluginId()
	{
		return this.pluginId;
	}

	/**
	 * @param pluginId
	 *            the pluginId to set
	 */
	public void setPluginId(String pluginId)
	{
		this.pluginId = pluginId;
	}

	/**
	 * @return the accessLevel
	 */
	public String getAccessLevel() {
		return accessLevel;
	}

	/**
	 * @param accessLevel the accessLevel to set
	 */
	public void setAccessLevel(String accessLevel) {
		this.accessLevel = accessLevel;
	}

	/**
	 * @return the allocationStrategyClass
	 */
	public String getAllocationStrategyClass() {
		return allocationStrategyClass;
	}

	/**
	 * @param allocationStrategyClass the allocationStrategyClass to set
	 */
	public void setAllocationStrategyClass(String allocationStrategyClass) {
		this.allocationStrategyClass = allocationStrategyClass;
	}

	
	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * @return the functionalType
	 */
	public String getFunctionalType() {
		return functionalType;
	}

	/**
	 * @param functionalType the functionalType to set
	 */
	public void setFunctionalType(String functionalType) {
		this.functionalType = functionalType;
	}

	/**
	 * @return the isInternallyAcquired
	 */
	public Boolean getIsInternallyAcquired() {
		return isInternallyAcquired;
	}

	/**
	 * @param isInternallyAcquired the isInternallyAcquired to set
	 */
	public void setIsInternallyAcquired(Boolean isInternallyAcquired) {
		this.isInternallyAcquired = isInternallyAcquired;
	}

	/**
	 * @return the version
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(int version) {
		this.version = version;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone()
	{
		try
		{
			return super.clone();
		}
		catch(CloneNotSupportedException e)
		{
			return null;
		}
	}

	@Override
	public String toString() {
		String result = null;
		result = "Plugin ID: " + getPluginId() + " | " +
				 "Extension ID: " + getExtensionId() + " | " +
				 "Name: " + getName() + " | " +
				 "Description: " + getDescription() + " | " +
				 "System ID: " + getSystemId() + " | " +
				 "Allocation Strategy Class: " + getAllocationStrategyClass() + " | " +
				 "Access Level: " + getAccessLevel() + " | " +
				 "Internally Acquired: " + getIsInternallyAcquired() + " | " +
				 "Image Path: " + getImagePath();
		return result;
	}
	
}
