/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.jbpm.gd.jpdl.Constants;

/**
 * The graphical viewer for the node definition editor. A viewer is responsible for the editpart
 * lifecycle. Editparts have visuals, such as TreeItems or Figures, which are hosted by the viewer
 * and its control. The viewer provides targeting of editparts via their visuals.
 * 
 * @author Imran Naqvi
 * 
 */
public abstract class NodeDefinitionGraphicalViewer extends ScrollingGraphicalViewer {

	private NodeDefinitionEditor editor;

	/**
	 * Ctor.
	 * 
	 * @param editor
	 *            The editor to which this viewer belongs
	 */
	public NodeDefinitionGraphicalViewer(NodeDefinitionEditor editor) {
		this.editor = editor;
		editor.getSelectionSynchronizer().addViewer(this);
		setKeyHandler(new GraphicalViewerKeyHandler(this));
		setRootEditPart(new ScalableFreeformRootEditPart());
		prepareGrid();
	}

	/**
	 * Initializes the edit part factory.
	 */
	protected abstract void initEditPartFactory();

	/**
	 * Initialize UI control.
	 * 
	 * @param parent
	 *            the parent composite
	 */
	public void initControl(Composite parent) {
		super.createControl(parent);
		getControl().setBackground(ColorConstants.white);
		NodeDefinitionContextMenuProvider provider = new NodeDefinitionContextMenuProvider(this, editor.getActionRegistry());
		setContextMenu(provider);
		editor.getEditDomain().addViewer(this);
		initEditPartFactory();
		setContents(editor.getRootContainer());
	}

	/**
	 * Gets the control dimensions.
	 * 
	 * @return the control dimensions
	 */
	public Dimension getDimension() {
		Rectangle rectangle = getControl().getBounds();
		return new Dimension(rectangle.width, rectangle.height);
	}

	/**
	 * @see org.eclipse.gef.ui.parts.ScrollingGraphicalViewer#getFigureCanvas()
	 */
	public FigureCanvas getFigureCanvas() {
		return super.getFigureCanvas();
	}

	/**
	 * Gets the editor to which this viewer belongs.
	 * 
	 * @return the editor to which this viewer belongs
	 */
	public NodeDefinitionEditor getEditor() {
		return editor;
	}

	private void prepareGrid() {
		getLayerManager().getLayer(LayerConstants.GRID_LAYER).setForegroundColor(
				Constants.veryLightBlue);
		editor.getActionRegistry().registerAction(new ToggleGridAction(this));
	}

}
