/*
 * Created on Sep 26, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.HeartbeatSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.InitializationSectionPart;

/**
 * The ResourceType Form Page containing the Management Configuration Controls
 * 
 * @author Vijay Silva
 */
public class ManagementPage extends ResourceTypeFormPage
{
	private static final String PAGE_TITLE = "Management";

	private static final String PAGE_HEADER = "Management Configuration";

	public static final String PAGE_ID = "ResourceType.ManagementPage";

	protected InitializationSectionPart initializationPart;

	protected HeartbeatSectionPart heartbeatPart;

	/**
	 * @param editor
	 *            The Parent Editor
	 */
	public ManagementPage(ResourceTypeEditor editor)
	{
		super(editor, PAGE_ID, PAGE_TITLE);
	}

	/*
	 * Create the Controls displayed in the composite
	 */
	@Override
	protected void createPageControls()
	{
		IManagedForm managedForm = this.getManagedForm();
		ScrolledForm form = managedForm.getForm();
		form.setText(PAGE_HEADER);

		Composite formBody = form.getBody();
		FormToolkit toolkit = managedForm.getToolkit();

		/* Create the Initialization Section Part */
		int style = getDefaultSectionStyle();
		this.initializationPart = new InitializationSectionPart(this, formBody, toolkit, style);
		this.initializationPart.getSection().setText("Initialization Configuration");
		managedForm.addPart(this.initializationPart);

		/* Create the Heartbeat Section Part */
		this.heartbeatPart = new HeartbeatSectionPart(this, formBody, toolkit, style);
		this.heartbeatPart.getSection().setText("Heartbeat Configuration");
		managedForm.addPart(this.heartbeatPart);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage#initializePageLayout()
	 */
	@Override
	protected void initializePageLayout()
	{
		Composite formBody = this.getManagedForm().getForm().getBody();

		/* Set the Form Layout */
		formBody.setLayout(this.createGridLayout(1, false));

		/* Set the Layout Data for the Initialization Section in the Form */
		this.initializationPart.getSection().setLayoutData(this.createSectionGridData());

		/* Set the Layout Data for the Heartbeat Section in the Form */
		this.heartbeatPart.getSection().setLayoutData(this.createSectionGridData());
	}
}
