package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition.NodeDefinitionVariablesContentProvider;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class SuperStateVariablesSectionComposite {

    private final Composite parent;
    private final TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite composite;
    private Label messageLabel;
    private Button buttonAdd;
    private Button buttonRemove;
    private Table table;
    private TableViewer tableViewer;
    private final String[] columnTitles = new String[] { "Name", "Attachment", "Type", "Composite Key" };
    private SuperStateVariablesCellModifier cellModifier;
    private TableColumn attachmentColumn;
    private TableColumn compositeKeyColumn;

    public SuperStateVariablesSectionComposite(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.parent = parent;
        this.widgetFactory = widgetFactory;

        createComponents();
    }

    private void createComponents() {
        this.composite = widgetFactory.createFlatFormComposite(parent);

        createButtons();
        createTable();
        createTableViewer();
    }

    private void createButtons() {
        buttonAdd = widgetFactory.createButton(composite, "+", SWT.PUSH);
        FormData formData = new FormData();
        formData.top = new FormAttachment(messageLabel, 5);
        formData.right = new FormAttachment(100, -35);
        formData.width = 25;
        buttonAdd.setLayoutData(formData);
        buttonAdd.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                NodeDefinition superState = (NodeDefinition) tableViewer.getInput();
                WPVariable variable = superState.addEmptySuperstateVariable();

                tableViewer.add(variable);
            }
        });

        buttonRemove = widgetFactory.createButton(composite, "-", SWT.PUSH);
        formData = new FormData();
        formData.top = new FormAttachment(buttonAdd);
        formData.right = new FormAttachment(buttonAdd, 0, SWT.RIGHT);
        formData.width = 25;
        buttonRemove.setLayoutData(formData);
        buttonRemove.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                if (((IStructuredSelection) tableViewer.getSelection()).getFirstElement() != null) {
                    NodeDefinition superState = (NodeDefinition) tableViewer.getInput();
                    WPVariable variable = (WPVariable) ((IStructuredSelection) tableViewer.getSelection())
                            .getFirstElement();

                    superState.removeVariable(variable.getMappedName());

                    tableViewer.remove(variable);
                }
            }
        });
    }

    private void createTable() {
        //table will be created in a exclusive parent in order to use TableColumnLayout
        Composite exclusiveTableParent = widgetFactory.createFlatFormComposite(composite);

        int tableStyle = SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
        table = widgetFactory.createTable(exclusiveTableParent, tableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);

        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment(messageLabel, 5);
        formData.right = new FormAttachment(buttonAdd, 0, SWT.LEFT);
        formData.width = 600; // trick: it has to be set in order to have TableColumnLayout working properly
        exclusiveTableParent.setLayoutData(formData);

        TableColumn nameColumn = new TableColumn(table, SWT.LEFT);
        nameColumn.setText(columnTitles[0]);
        attachmentColumn = new TableColumn(table, SWT.CENTER);
        attachmentColumn.setText(columnTitles[1]);
        TableColumn typeColumn = new TableColumn(table, SWT.LEFT);
        typeColumn.setText(columnTitles[2]);
        compositeKeyColumn = new TableColumn(table, SWT.CENTER);
        compositeKeyColumn.setText(columnTitles[3]);

        TableColumnLayout layout = new TableColumnLayout();
        exclusiveTableParent.setLayout(layout);
        layout.setColumnData(nameColumn, new ColumnWeightData(30));
        layout.setColumnData(attachmentColumn, new ColumnWeightData(20));
        layout.setColumnData(typeColumn, new ColumnWeightData(10));
        layout.setColumnData(compositeKeyColumn, new ColumnWeightData(20));
    }

    private void createTableViewer() {
        tableViewer = new TableViewer(table);

        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(columnTitles);
        tableViewer.setContentProvider(new NodeDefinitionVariablesContentProvider());
        tableViewer.setLabelProvider(new SuperStateVariablesLabelProvider(attachmentColumn, compositeKeyColumn));

        CellEditor[] editors = new CellEditor[columnTitles.length];
        editors[0] = new TextCellEditor(table, SWT.BORDER);
        editors[1] = new CheckboxCellEditor(table);
        editors[2] = new ComboBoxCellEditor(table, Utility.toVariableTypeName(Utility.getWPDataTypes()), SWT.BORDER);
        editors[3] = new CheckboxCellEditor(table);

        // Assign the cell editors to the viewer 
        tableViewer.setCellEditors(editors);

        cellModifier = new SuperStateVariablesCellModifier(tableViewer, columnTitles);

        // Set the cell modifier for the viewer
        tableViewer.setCellModifier(cellModifier);

        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, attachmentColumn);
        viewerColumn.setLabelProvider((CellLabelProvider) tableViewer.getLabelProvider());
        viewerColumn = new TableViewerColumn(tableViewer, compositeKeyColumn);
        viewerColumn.setLabelProvider((CellLabelProvider) tableViewer.getLabelProvider());
    }

    public void setInput(NodeDefinition superState) {
        tableViewer.setInput(superState);
    }
}