/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter for single node node definitions.
 * 
 * @author Imran Naqvi
 * 
 */
public class SingleNodeDefinitionFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		/* return false if modelElement is not a node definition */
		if (!(modelElement instanceof NodeDefinition))
			return false;

		return ((NodeDefinition) modelElement).getNodeType() == NodeDefinitionType.MessageNode;
	}

}
