/**
 * AddSuperStateCommand.java
 * Created Apr 23, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import static javax.xml.xpath.XPathConstants.NODESET;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.SynchronizationException;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.util.FileUtil;

/**
 * Adds a superstate to a resource type
 * 
 * @author Sahil Verma
 */
public class AddSuperStateCommand extends AddNodeCommand {

	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public AddSuperStateCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void updateRelationships() {
		super.updateRelationships();
		
		ResourceType type = model.getResourceType();
		
		/* Set the persisted id of the children, if they are already in the persistent store */
		for (NodeDefinitionDTO child : this.model.getChildren()) {
			NodeDefinitionDTO node = type.getNode(child.getName());
			
			if (node != null)
				child.setId(node.getId());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void updateNodeDefinitionXml() {
		try {
			Document document = Utility.getDocumentFromString(model.getXml());
			Element e = document.getDocumentElement();

			e.setAttribute("resourceType", String.valueOf(model.getResourceType().getId()));

			XPath xpath = XPathFactory.newInstance().newXPath();
			NodeList nodelist = (NodeList) xpath.evaluate("//super-state/nodeDefinition", e, NODESET);

			/* Set the persisted id and resourceType id of each child node */
			for (int i = 0; i < nodelist.getLength(); i++) {
				Element dom = (Element) nodelist.item(i);
				String name = dom.getAttribute("definitionName");

				dom.setAttribute("resourceType", String.valueOf(model.getResourceType().getId()));

				for (NodeDefinitionDTO child : model.getChildren()) {
					if (child.getName().equals(name)) {
						dom.setAttribute("id", String.valueOf(child.getId()));
						break;
					}
				}
			}

			String xml = FileUtil.convertDocument(document);

			model.setXml(xml);
		} catch (XPathException e) {
			throw new SynchronizationException("Failed to convert node XML", e);
		} catch (TransformerException e) {
			throw new SynchronizationException("Failed to convert node XML", e);
		}
	}
}
