/**
 * AbstractVariableCommand.java
 * Created May 10, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.template;

import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Parent class of commands that are related to variables being added, removed or updated
 * 
 * @author Sahil Verma
 */
public abstract class AbstractVariableCommand extends AbstractDiffCommand {
	
	/**
	 * The variable
	 */
	protected WPVariable variable;
	
	protected WorkflowTemplateDTO model;

	/**
	 * Template UI model
	 */
	protected NodeElementContainer container;
	
	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public AbstractVariableCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		this.variable = WPVariable.class.cast(diff.getElement());
	}

	/**
	 * @return the model
	 */
	public WorkflowTemplateDTO getModel() {
		return model;
	}

	/**
	 * @param model the model to set
	 */
	public void setModel(WorkflowTemplateDTO model) {
		this.model = model;
	}

	/**
	 * @return the container
	 */
	public NodeElementContainer getNodeElementContainer() {
		return container;
	}

	/**
	 * @param container the container to set
	 */
	public void setNodeElementContainer(NodeElementContainer container) {
		this.container = container;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Template " + model.getName() + ", variable " + variable.getMappedName() + " " + diff.getKind();
	}
}
