package com.tandbergtv.watchpoint.studio.ui.view.resourcegroup;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ResourceGroupLabelProvider extends LabelProvider {
	
	private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
	
	private static final String RESOURCE_GROUP_IMAGE_PATH = "resource_group.png";

	/**
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	@Override
	public String getText(Object element) {
		String name=null;
		if(element instanceof ResourceType)
		{
			ResourceType resourceType = (ResourceType) element;
			name= resourceType.getName()+ " [" + resourceType.getSystemId() + "]";
		}else if(element instanceof ResourceGroup){
			name= ((ResourceGroup) element).getName();
		}else
		{
			name = super.getText(element);
		}
		return name;
	}

	/** 
	 * @see org.eclipse.jface.viewers.LabelProvider#getImage(java.lang.Object)
	 */
	@Override
	public Image getImage(Object element) {
		Image image = null;
		if (element instanceof ResourceType)
		{
			String imagePath = RESOURCE_TYPE_IMAGE_PATH;
			image = this.createImage(imagePath);

		}
		else if (element instanceof ResourceGroup)
		{
			String imagePath = RESOURCE_GROUP_IMAGE_PATH;
			image = this.createImage(imagePath);
		}
		else
		{
			image = super.getImage(element);
		}

		return image;
	}
	/*
	 * Create a new Image from the relative path, or null if the path is null.
	 */
	private Image createImage(String path)
	{
		if (path == null)
			return null;

		ImageDescriptor descriptor = Utility.getImageDescriptor(path);
		return new Image(Display.getCurrent(), descriptor.getImageData());
	}

}
