package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import static org.eclipse.swt.widgets.Display.getCurrent;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.Window;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Description;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.ResourceTypeMessageParameterDeleteDialog;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;

public class DeleteParameterAction extends AbstractNodeDefinitionAction{
	private WPVariable variable;
	private NameValuePair constant;
	private NodeDefinitionDTO nodeDefinitionDTO;
	ResourceTypeMessageParameterDeleteDialog dialog;
	
	@Override
	public void run(IAction action) {
		NodeDefinition nodeDefParsed = null;
		try {
			nodeDefParsed = SemanticElementUtil.createNodeDefinition(nodeDefinitionDTO.getXml());
			nodeDefParsed.setId(nodeDefinitionDTO.getId());
        } catch (Exception e) {
			handleException("Error creating Node Definition from NodeDefinitionDTO xml", e);
		}
		
		/* get the references for the node if the node is being used by templates or superstates*/
		this.nodeReferences = checkNodeInUse(nodeDefParsed);
		
		dialog = buildDialog(nodeDefParsed);
		if (dialog.open() != Window.OK)
			return;
		
		try {
			NodeDefinitionDTO nodeDTOAlias = nodeDefinitionDTO;
			
			XmlAdapter adapter = Utility.getAdapterFromString(nodeDTOAlias.getXml(),
					nodeDefParsed.getFactory());
			adapter.initialize(nodeDefParsed);
			
			deleteParameter(nodeDefParsed);
			
			/* Check if the node definition is being used in a superstate. If true, updates the
			   superstate */
			for (IWatchPointDTO referenceDTO : this.nodeReferences) {
				if(referenceDTO instanceof NodeDefinitionDTO){
					NodeDefinitionDTO nodeDTO = (NodeDefinitionDTO) referenceDTO;
					if(nodeDTO.getType().equals(NodeDefinitionType.SuperState)){
						updateSuperstateNodeDefinition(nodeDTO, nodeDefParsed, nodeDefinitionDTO.getName());
					}
				}
			}
			
			String xml = Utility.getXMLFromDocument(adapter.getNode()
					.getOwnerDocument());
			nodeDTOAlias.setXml(xml);
			
			INodeDefinitionService service = ServiceFactory.createFactory()
			.createNodeDefinitionService();
			service.updateNodeDefinitionInFileSystem(nodeDTOAlias);
			
			if(dialog.getUpdateReferences()){
				try {
					new TemplateNodesRefactoring().refactorMessageNodes(dialog.getAffectedMessages(), nodeDefinitionDTO, nodeDefinitionDTO.getName());
				} catch (InvocationTargetException e) {
					handleException("Error refactoring the message nodes", e);
				} catch (InterruptedException e) {
					handleException("Error refactoring the message nodes", e);
				}
			}
		} catch (ServiceException e) {
			Utility.handleException(ServiceErrors.getInstance().getProperty(
					e.getServiceErrorCode().getCode()), e);
		}
	}
	
	@Override
	protected void updateNodeInSuperstate(NodeDefinition nodeSuperstate) {
		deleteParameter(nodeSuperstate);
	}
	
	protected void deleteParameter(NodeDefinition nodeDefParsed){
		
		WPVariable var = null;
		//for constant case
		NameValuePair nvvar = null;
		if(variable != null){
			var = variable;
		}else{
			if(constant != null){
				nvvar = constant;
			}
		}
		
		if(nvvar != null){
			nodeDefParsed.setConstantValue(nvvar.getName(), null);
		}else{
			if (!var.isCompositeKey())
				((IMessageContainer) nodeDefParsed.getNode()).removeVariable(var.getMappedName());
			else
				nodeDefParsed.setCompositeKey(var.getMappedName(), null);
		}
		Description description = nodeDefParsed.getDescription();
		
		String desc = (description != null) ? description
				.getDescription() : null;

		if (description != null) {
			if (variable != null) {
				description.setDescription(parseDescription(desc, var.getMappedName(), null));
			}else{
				if(constant != null){
					description.setDescription(parseDescription(desc, nvvar.getName(),
						null));
				}
			}
		}
		
		
	}
	
	protected ResourceTypeMessageParameterDeleteDialog buildDialog(NodeDefinition node) {
		ResourceTypeMessageParameterDeleteDialog dialog = 
			new ResourceTypeMessageParameterDeleteDialog(getCurrent().getActiveShell());
		
		dialog.initReferences( buildReferencesMap(nodeDefinitionDTO) );
		dialog.setMessageName(nodeDefinitionDTO.getName());
		
		dialog.setBlockOnOpen(true);
		return dialog;
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(!selection.isEmpty()){
			// Gets the node definition
			TreePath[] paths = ((TreeSelection) selection).getPaths();
			TreePath path = (paths != null) ? paths[0] : null;
			if(path != null){
				this.nodeDefinitionDTO = (NodeDefinitionDTO) path.getSegment(2);
			}
			// Gets the WPVariable
			Object element = ((TreeSelection) selection).getFirstElement();
			if (element instanceof WPVariable) {
				this.variable = (WPVariable) element;
			}
			// Gets the name value pair
			if (element instanceof NameValuePair) {
				this.constant = (NameValuePair) element;
			}
		}
	}

}
