/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExporterInputAttributes;
import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * @param <WPO> The Type of the WatchPointDTO object
 * 
 * @author Raj Prakash
 */
public abstract class WPDTOExportWizard<WPO extends IWatchPointDTO> extends Wizard {

	private WPO dtoObject;
	
	private ExportSelectDirPage exportDirPage;
	
	private SelectFilesAndDirsPage classesPage, resourcesPage, librariesPage;
	
	public WPDTOExportWizard(WPO dto, String name, String suffix, String title) {
		this.dtoObject = dto;
		
		exportDirPage = new ExportSelectDirPage(title);
		exportDirPage.setTitle(title);
		exportDirPage.setDescription("Select the export folder");
		exportDirPage.setSuffix(suffix);
		
		IDialogSettings rootsettings = WatchPointStudioPlugin.getDefault().getDialogSettings();
		
		setDialogSettings(getSettings(rootsettings, name));
	}

	public IDialogSettings getSettings(IDialogSettings rootsettings, String name) {
		IDialogSettings settings = rootsettings.getSection(name);
		
		if (settings == null)
			settings = rootsettings.addNewSection(name);
		
		return settings;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		saveSettings();
		
		Map<String, Object> exportInputAttrs = new HashMap<String, Object>();
        exportInputAttrs.put(ExporterInputAttributes.EXPORT_FOLDER_PATH, exportDirPage.getSelectedDir());
        exportInputAttrs.put(ExporterInputAttributes.PLUGIN_CLASSES_FILE_PATHS, Arrays.asList(classesPage.getItems()));
        exportInputAttrs.put(ExporterInputAttributes.PLUGIN_RESOURCE_FILE_PATHS, Arrays.asList(resourcesPage.getItems()));
        exportInputAttrs.put(ExporterInputAttributes.PLUGIN_JAR_FILE_PATHS, Arrays.asList(librariesPage.getItems()));

        try {
        	export(this.dtoObject, exportInputAttrs);
        	MessageDialog.openInformation(super.getShell(), "Export", "Export was successful.");
			return true;
		} catch (Exception e) {
			Utility.reportError("Export Failed", e);
			return false;
		}
	}

	@Override
	public void addPages() {
		addPage(exportDirPage);

		this.classesPage = new SelectFilesAndDirsPage("Classes", true);
		this.classesPage.setTitle("Classes");
		this.classesPage.setDescription("Select classes to include in export");
		this.classesPage.setLabel("Class Files and Directories:");
		addPage(this.classesPage);
		
		this.resourcesPage = new SelectFilesAndDirsPage("Resources", true);
		this.resourcesPage.setTitle("Resources");
		this.resourcesPage.setDescription("Select resources to include in export");
		this.resourcesPage.setLabel("Resource Files and Directories:");
		addPage(this.resourcesPage);
		
		this.librariesPage = new SelectFilesAndDirsPage("Libraries", false);
		this.librariesPage.setTitle("Libraries");
		this.librariesPage.setDescription("Select libraries to include in export");
		this.librariesPage.setLabel("Library Files:");
		addPage(this.librariesPage);
	}
	
	protected abstract void export(WPO dtoObject, Map<String, Object> exportInputAttrs) throws ExportFailureException;
	
	protected void saveSettings() {
		IDialogSettings settings = getDialogSettings();
		
		for (IWizardPage page : getPages()) {
			if (page instanceof AbstractWizardPage)
				((AbstractWizardPage) page).saveSettings(settings);
		}
	}
}
