/**
 * TemplateImportWizard.java
 * Created Feb 25, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.template;

import java.util.Collection;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

import com.tandbergtv.watchpoint.studio.builder.WatchpointTemplateNature;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardDestinationProjectPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardFirstPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardListPage;

/**
 * @author Sahil Verma
 */
public class TemplateImportWizard extends ImportWizard {
	ImportWizardDestinationProjectPage page4;
	
	/**
	 * @param clazz
	 */
	public TemplateImportWizard() {
		super(WorkflowTemplateDTO.class, "Import Workflow Templates");
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addPages() {
		setNeedsProgressMonitor(true);
		
		page1 = new ImportWizardFirstPage("Choose Import Directory", this.clazz);
		
		page1.addProvider(WorkflowTemplateDTO.class, new TemplateDataProvider());
		
		addPage(page1);
		
		page2 = new ImportWizardListPage("Selection", page1, this.selection);
		
		addPage(page2);
		
		page4 = new ImportWizardDestinationProjectPage("Project", clazz);
		page4.setRequiredProjectNatures(WatchpointTemplateNature.NATURE_ID);
		
		addPage(page4);
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean performFinish() {
		page1.saveSettings(getDialogSettings());
		page2.saveSettings(getDialogSettings());
		page4.saveSettings(getDialogSettings());
		
		TemplateImportService importService = new TemplateImportService();
		IPath path = new Path(page4.getBaseDirectory());
		IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
		importService.importItems((Collection<WorkflowTemplateDTO>) page2.getSelectedModels(), folder);
		
		return true;
	}
}
