package com.tandbergtv.watchpoint.studio.validation.impl;

import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.IValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;

/**
 * This class provides a sample implementation of a IValidationMessageAdder to be reused in the entire application whenever it is needed. 
 */
public final class ValidationMessageAdder implements IValidationMessageAdder {

    private ValidationMessageCodeAndTypeMapper validationTypeMapper = ValidationMessageCodeAndTypeMapper.getInstance();
    
    private static ValidationMessageAdder instance;

    private ValidationMessageAdder() {
    }
    
    public static IValidationMessageAdder getInstance() {
        if (instance == null) {
            instance = new ValidationMessageAdder();
        } else {
            // code to force update of properties from preference store every time the singleton is called
            instance.validationTypeMapper = ValidationMessageCodeAndTypeMapper.getInstance();
        }
        return instance;
    }

    @Override
    public ValidationMessage addValidationMessage(List<ValidationMessage> messages, Object node, ValidationMessageCode code) {
        ValidationMessage validationMessage = createValidationMessage(node, code);
        if (validationMessage != null) {
            messages.add(validationMessage);
        }
        return validationMessage;
    }

    @Override
    public ValidationMessage addValidationMessage(List<ValidationMessage> messages, Object node,
            ValidationMessageCode code, List<String> params) {
        ValidationMessage validationMessage = createValidationMessage(node, code, params);
        if (validationMessage != null) {
            messages.add(validationMessage);
        }
        return validationMessage;
    }

    @Override
    public ValidationMessage createValidationMessage(Object node, ValidationMessageCode code) {
        if (validationTypeMapper.map(code) != null) {
            return new ValidationMessage(node, validationTypeMapper.map(code), code);
        }
        return null;
    }

    @Override
    public ValidationMessage createValidationMessage(Object node, ValidationMessageCode code, List<String> params) {
        if (validationTypeMapper.map(code) != null) {
            return new ValidationMessage(node, validationTypeMapper.map(code), code, params);
        }
        return null;
    }
}