/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * This class validates the each of the Transitions from a Node do not contain an Expression unless
 * the Node Element is a Decision Node. In case the condition is present, it can only be an
 * expression, not a script.
 * 
 * @author DReddy
 * @author Vijay Silva
 */
public class TransitionsConditionRule extends ValidationRule<NodeElement> {

	/**
	 * Validate that all the outgoing transitions from the Node Element do not contain a conditional
	 * expression unless the node is a Decision node.
	 * 
	 * @param target
	 *            The Node Element to validate
	 * 
	 * @return The list of Validation Messages
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(NodeElement target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		Transition[] transitions = target.getTransitions();
		if (transitions != null) {
			for (Transition transition : transitions) {
				this.validateCondition(target, transition, messages);
			}
		}

		return messages;
	}

	/*
	 * Validate that the outgoing Transition from the Node does not contain Condition unless it is a
	 * Decision Node.
	 */
	private void validateCondition(NodeElement target, Transition transition,
			List<ValidationMessage> messages) {
		Condition condition = (transition != null) ? transition.getCondition() : null;
		if ((!(target instanceof Decision)) && condition != null) {
			ValidationMessageCode code = ValidationMessageCode.TRANSITION_CONDITION_NOT_FROM_DECISION;
			List<String> parameters = new ArrayList<String>();
			parameters.add(target.getName());
			ValidationMessageAdder.getInstance().addValidationMessage(messages, transition, code, parameters);
		}
	}
}
