/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.core.graph;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.SuperState2;
import java.util.List;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Loop2
extends SuperState {
    private static final long serialVersionUID = -2696666366298339153L;
    private String variable;
    private String index;
    private int initialValue;
    private String expression;

    public void read(Element element, JpdlXmlReader jpdlReader) {
        super.read(element, jpdlReader);
        this.variable = element.attributeValue("variable");
        this.index = element.attributeValue("index");
        if (this.index == null || this.index.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have an index variable");
        }
        this.initialValue = Integer.valueOf(element.attributeValue("initialValue", "0"));
        this.expression = element.attributeValue("expression");
        if (this.nodes == null || this.nodes.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have child nodes");
        }
    }

    public Transition getDefaultLeavingTransition() {
        List transitions;
        if (this.superState != null && this.superState.getParent() instanceof Loop2 && ((transitions = this.superState.getLeavingTransitions()) == null || transitions.isEmpty())) {
            return this.createLeavingTransition();
        }
        return super.getDefaultLeavingTransition();
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getArrivingTransitions() != null && !node.getArrivingTransitions().isEmpty()) continue;
            return node;
        }
        throw new JbpmException(String.valueOf(this.name) + " has no nodes to delegate execution");
    }

    public Node last() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getLeavingTransitions() != null && !node.getLeavingTransitions().isEmpty()) continue;
            return node;
        }
        throw new JbpmException(String.valueOf(this.name) + " has no nodes to finish execution");
    }

    public void incrementIndex(ExecutionContext context) {
        Integer i = (Integer)context.getVariable(this.index);
        context.setVariable(this.index, (Object)(i + 1));
    }

    public boolean evaluateExpression(ExecutionContext context) {
        return Boolean.parseBoolean(JbpmExpressionEvaluator.evaluate((String)this.expression, (ExecutionContext)context).toString());
    }

    protected Transition getArrivingTransition(Node node) {
        if (node.getArrivingTransitions() != null && !node.getArrivingTransitions().isEmpty()) {
            return (Transition)node.getArrivingTransitions().iterator().next();
        }
        Node target = node instanceof SuperState2 ? ((SuperState2)((Object)SuperState2.class.cast(node))).first() : node;
        Transition transition = new Transition(){
            private static final long serialVersionUID = 1L;

            public void take(ExecutionContext context) {
                this.fireEvent("transition", context);
            }
        };
        transition.setTo(target);
        transition.setProcessDefinition(this.processDefinition);
        if (!(this.getSuperState() instanceof SuperState2)) {
            this.addEvent(transition, "resource-request");
        }
        return transition;
    }

    protected Transition createLeavingTransition() {
        Transition transition = new Transition(){
            private static final long serialVersionUID = 1L;

            public void take(ExecutionContext context) {
                Loop2.this.superState.leave(context);
                this.fireEvent("transition", context);
            }
        };
        transition.setFrom((Node)this);
        transition.setProcessDefinition(this.processDefinition);
        return transition;
    }

    protected void addEvent(Transition transition, String action) {
        Event event = new Event((GraphElement)transition, "transition");
        Action a = transition.getProcessDefinition().getAction(action);
        event.addAction(new Action(a.getActionDelegation()));
        transition.addEvent(event);
    }

    public String getIndex() {
        return this.index;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public String getExpression() {
        return this.expression;
    }
}

