/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugTarget;
import com.tandbergtv.watchpoint.studio.debugger.util.Base64Encoder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.Breakpoint;

public class NodeBreakpoint
extends Breakpoint {
    protected static final String NODE_NAME = "nodeName";

    public NodeBreakpoint() {
    }

    public NodeBreakpoint(final IResource resource, final String node) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.tandbergtv.watchpoint.studio.debugger.nodeBreakpoint.marker");
                NodeBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute(NodeBreakpoint.NODE_NAME, (Object)node);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)NodeBreakpoint.this.getModelIdentifier());
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public String getModelIdentifier() {
        return "com.tandbergtv.watchpoint.studio.debugger.jpdl";
    }

    public String getNodeName() {
        try {
            return (String)this.getMarker().getAttribute(NODE_NAME);
        }
        catch (CoreException e) {
            return null;
        }
    }

    public String getResourceName() {
        return this.getMarker().getResource().getName();
    }

    public String serializeNodeName() {
        String originalNodeName = this.getNodeName();
        return Base64Encoder.encode(originalNodeName);
    }

    public boolean canBeAdded() {
        return JpdlDebugTarget.getInstance() == null || JpdlDebugTarget.getInstance().isTerminated();
    }

    public boolean canBeRemoved() {
        return JpdlDebugTarget.getInstance() == null || JpdlDebugTarget.getInstance().isTerminated();
    }
}

