/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;
import java.util.Collection;
import java.util.List;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class NodeSimulator {
    protected Node node;
    protected NodeSimulationConfig simulationConfig;
    protected ExecutionContext executionContext;
    protected NodeSimulationException exception;

    public final void startSimulation(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        try {
            this.simulate();
        }
        catch (Exception e) {
            if (e instanceof NodeSimulationException) {
                this.exception = (NodeSimulationException)e;
            }
            e.printStackTrace();
            String message = "Unexpected error while trying to simulate the node.";
            this.exception = new NodeSimulationException(message, this.node, this, e);
        }
    }

    protected abstract void simulate() throws Exception;

    public List<?> getLeavingTransitions() {
        List leavingTransitions = null;
        if (this.node != null) {
            leavingTransitions = this.node.getLeavingTransitions();
        }
        return leavingTransitions;
    }

    public boolean fail() {
        return this.exception != null;
    }

    public NodeSimulationException getException() {
        return this.exception;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodeSimulationConfig getSimulationConfig() {
        return this.simulationConfig;
    }

    public void setSimulationConfig(NodeSimulationConfig simulationConfig) {
        this.simulationConfig = simulationConfig;
    }

    public abstract Collection<VariableAccess> getVariables();
}

