/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.model.DecisionSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.ui.AbstractNodeSimulationComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

public class DecisionNodeSimulationComposite
extends AbstractNodeSimulationComposite {
    protected Label lblFixedTransition;
    protected Combo cmbFixedTransition;

    public DecisionNodeSimulationComposite(Composite parent, NodeSimulationConfig node) {
        super(parent, node);
    }

    @Override
    protected void createAdditionalControls(Composite parent) {
        this.createFixedTransitionWidget(parent);
    }

    protected void createFixedTransitionWidget(Composite composite) {
        this.lblFixedTransition = new Label(composite, 0);
        this.lblFixedTransition.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblFixedTransition.setText("Fixed Transition :");
        this.cmbFixedTransition = new Combo(composite, 0);
        this.cmbFixedTransition.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void load(NodeSimulationConfig nodeSimulationConfig) {
        super.load(nodeSimulationConfig);
        NodeElement nodeElement = nodeSimulationConfig.getNodeElement();
        this.cmbFixedTransition.add("");
        Transition[] transitionArray = nodeElement.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray[n2];
            this.cmbFixedTransition.add(transition.getName());
            ++n2;
        }
        String fixedTransition = this.getSimulationData().getFixedTransitionName();
        if (fixedTransition != null) {
            this.cmbFixedTransition.setText(fixedTransition);
        }
        this.updateWidgets();
    }

    public DecisionSimulationData getSimulationData() {
        DecisionSimulationData result = null;
        result = !(this.nodeSimulationConfig.getSimulationData() instanceof DecisionSimulationData) ? new DecisionSimulationData(this.nodeSimulationConfig.getSimulationData()) : (DecisionSimulationData)this.nodeSimulationConfig.getSimulationData();
        this.nodeSimulationConfig.setSimulationData(result);
        return result;
    }

    @Override
    protected SimulationType[] getSimulationTypes() {
        return new SimulationType[]{SimulationType.EXECUTE, SimulationType.FIXED_TRANSITION};
    }

    protected void updateWidgets() {
        boolean isFixedTransition = SimulationType.FIXED_TRANSITION.equals((Object)this.nodeSimulationConfig.getSimulationType());
        this.cmbFixedTransition.setEnabled(isFixedTransition);
        this.lblFixedTransition.setEnabled(isFixedTransition);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Widget widget = (Widget)e.getSource();
        if (SimulationType.FIXED_TRANSITION.equals(widget.getData())) {
            Button btn = (Button)widget;
            if (btn.getSelection()) {
                this.nodeSimulationConfig.setSimulationType(SimulationType.FIXED_TRANSITION);
            }
            this.updateWidgets();
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        } else if (SimulationType.EXECUTE.equals(widget.getData())) {
            Button btn = (Button)widget;
            if (btn.getSelection()) {
                this.nodeSimulationConfig.setSimulationType(SimulationType.EXECUTE);
            }
            this.updateWidgets();
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        } else if (widget == this.cmbFixedTransition) {
            this.getSimulationData().setFixedTransitionName(this.cmbFixedTransition.getText());
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        }
    }
}

