package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import java.util.List;

import org.eclipse.core.resources.IResource;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.resource.UpdateMessageCommand;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class MessageNodeOutdatedResolution extends WatchpointStudioTemplateResolution {

	public MessageNodeOutdatedResolution(IResource resource, String element, Object message) {
        super(resource, element, message);
    }

    @Override
    public String getLabel() {
        return (String) message;
    }

    @Override
	public void run() {
		try {
			WorkflowTemplate template = getTemplate();
			
			INodeDefinitionService service = ServiceFactory.createFactory().createNodeDefinitionService();
			NodeDefinition templateNode = (NodeDefinition) getNodeElementByName(template, getElement().toString());
			
			NodeDefinitionDTO remoteNode = null;
			List<NodeDefinitionDTO> remoteNodes = service.getNodeDefinitionsByMessageUID(templateNode.getUid(), NodeDefinitionType.MessageNode);
			if (remoteNodes.size() == 1) {
				remoteNode = remoteNodes.get(0);
				UpdateMessageCommand command = new UpdateMessageCommand(templateNode, remoteNode);
				command.execute();
				saveTemplate();
			}
		} catch (Exception e) {
			Utility.reportError("Error while updating Message node.", e);
		}
	}
}
