/**
 * NodeDefinitionWriter.java
 * Created Jan 26, 2010
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import static com.tandbergtv.watchpoint.studio.external.wpexport.ExporterInputAttributes.EXPORT_FOLDER_PATH;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.GPD_EXTENSION;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.PLUGIN_NODE_FOLDER;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.PLUGIN_RESOURCE_FOLDER_NAME;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.XML_EXTENSION;
import static java.io.File.separator;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import javax.xml.transform.TransformerException;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.util.FileUtil;

/**
 * Writes out node definitions for a resource type to the resources/ directory of the corresponding
 * plugin
 * 
 * @author Sahil Verma
 */
public class NodeDefinitionWriter {
	
	/**
	 * Writes node definitions of the specified resource type
	 * 
	 * @param rt
	 * @param properties
	 * @throws ExportFailureException
	 */
	public void writeNodeDefinitions(Collection<NodeDefinitionDTO> nodes, Map<String, Object> properties)
		throws ExportFailureException {
		/* Nodes go under plugin/resources/node/ */
		String dir = (String) properties.get(EXPORT_FOLDER_PATH) + separator + PLUGIN_RESOURCE_FOLDER_NAME +
			separator + PLUGIN_NODE_FOLDER;
		File f = new File(dir);
		
		if (f.exists())
			FileUtil.deleteFolderContents(f, true);
		
		if (!f.exists())
			f.mkdir();

		for (NodeDefinitionDTO node : nodes)
			writeNodeDefinition(node, dir);
	}

	private void writeNodeDefinition(NodeDefinitionDTO node, String path) throws ExportFailureException {
		String xml = node.getXml();
		String gpd = node.getGpd();

		try {
			writeXml(xml, path + separator + node.getName() + XML_EXTENSION);
			writeXml(gpd, path + separator + node.getName() + GPD_EXTENSION);
		} catch (Exception e) {
			throw new ExportFailureException("Could not write node definitions for " + node.getResourceType().getName(), e);
		}
	}

	private void writeXml(String xml, String path) throws TransformerException, IOException {
		FileUtil.writeXml(xml, path);
	}
}
