package com.tandbergtv.watchpoint.studio.ui;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/**
 * Base class of all UI exceptions thrown by the WatchPoint Studio UI.
 * 
 * @author inaqvi
 *
 */
public class UIException extends StudioRuntimeException {

	/* Serialization Version */
	private static final long serialVersionUID = -8448125245435711788L;

	/**
	 * Creates a UIException
	 */
	public UIException() {
		super();
	}

	/**
	 * Creates a UIException
	 * @param message
	 */
	public UIException(String message) {
		super(message);
	}

	/**
	 * Creates a UIException
	 * @param message
	 * @param cause
	 */
	public UIException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates a UIException
	 * @param cause
	 */
	public UIException(Throwable cause) {
		super(cause);
	}
}
