package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.EditorPluginAction;

@SuppressWarnings("restriction")
public class TemplateEditorPasteAction implements IEditorActionDelegate {
	private WatchPointTemplateEditor templateEditor;

	@Override
	public void run(IAction action) {
		if (action instanceof EditorPluginAction) {
			// Create command class
            TemplateEditorPasteCommand command = new TemplateEditorPasteCommand();
			command.setTemplateEditor(templateEditor);
			command.execute();
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		action.setEnabled(true);
	}

	@Override
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if(targetEditor != null && targetEditor instanceof WatchPointTemplateEditor){
			this.templateEditor = (WatchPointTemplateEditor) targetEditor;
		}
	}
}
