/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import static com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType.MessageNode;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.jbpm.gd.common.command.ChangeNameCommand;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.policy.DirectEditPolicy;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.notation.JpdlNodeContainer;
import org.jbpm.gd.jpdl.notation.JpdlRootContainer;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.template.UniqueNodeNameGenerator;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Manages the direct edit operation of graphical edit parts.
 * 
 * @author Imran Naqvi
 *
 */
public class WPDirectEditPolicy extends DirectEditPolicy {

	/**)
	 * @see org.jbpm.gd.common.policy.DirectEditPolicy#getDirectEditCommand(org.eclipse.gef.requests.DirectEditRequest)
	 */
	@Override
	protected Command getDirectEditCommand(DirectEditRequest request) {
		String value = request.getCellEditor().getValue().toString().trim();
		EditPart editPart = getHost();
		
		NamedElement namedElement = (NamedElement) ((NotationElement) editPart.getModel()).getSemanticElement();
		ChangeNameCommand command = new ChangeNameCommand();
		
		command.setNamedElement(namedElement);
		command.setName(value);
		
		/* Check to see if the new name is blank */
		if (namedElement.isNameMandatory() && "".equals(value))
			throw new StudioRuntimeException("Name cannot be blank.");

		if (!(namedElement instanceof NodeElement))
			return command;

		if (value.equals(namedElement.getName()))
			return command;

		NodeElementContainer container = getParentElement(editPart.getParent());

		/* Can't rename inner nodes of a node definition */
		if (namedElement instanceof AutomaticTaskNode && isNodeDefinition(container))
			throw new StudioRuntimeException("Changing the node name is not allowed");

		/* Checking to see if there is another node with this name */
		UniqueNodeNameGenerator nameHelper = new UniqueNodeNameGenerator(false);
		nameHelper.setRootContainer(container);

		if (nameHelper.nameExists(value))
			throw new StudioRuntimeException("There is already a node named " + value + ".");

		return command;
	}
	
	private boolean isNodeDefinition(NodeElementContainer container) {
		if (container instanceof NodeDefinition) {
			NodeDefinition node = NodeDefinition.class.cast(container);
			
			return node.getNodeType() == MessageNode;
		}
		
		return false;
	}
	
	protected NodeElementContainer getParentElement(EditPart editPart) {
		Object obj = editPart.getModel();

		if (obj instanceof JpdlRootContainer) {
			JpdlRootContainer rootContainer = JpdlRootContainer.class.cast(obj);

			if (rootContainer.getSemanticElement() instanceof NodeElementContainer)
				return (NodeElementContainer) rootContainer.getSemanticElement();
		} else if (obj instanceof JpdlNodeContainer){
			JpdlNodeContainer nodeContainer = JpdlNodeContainer.class.cast(obj);
			if (nodeContainer.getContainer() != null) {
				return (NodeElementContainer) nodeContainer.getContainer().getSemanticElement();
			} else if(nodeContainer.getSemanticElement() instanceof NodeElementContainer){
				return (NodeElementContainer) nodeContainer.getSemanticElement();
			}
		}
		
		return null;
	}
}
