package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.fields;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;

public class RTGeneralPageConTypeField implements IResourceTypeGeneralPageInputField{
	
	private Combo connTypeCombo;
	
	private Map<String, ConnectionType> connTypesNameObjMap = new HashMap<String, ConnectionType>();
	
	public RTGeneralPageConTypeField() {
		super();
	}
	
	@Override
	public void createControls(Composite parent, GridData labelData, GridData controlData) {
		//conn type label
		Label connTypeLabel = new Label(parent, SWT.NONE);
		connTypeLabel.setText("Connection Type : ");
		
		//conn type combo
		connTypeCombo = new Combo(parent, SWT.DROP_DOWN | SWT.SINGLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.READ_ONLY);
		
		//conn type label
		connTypeLabel.setLayoutData(labelData);
		
		//conn type combo
		connTypeCombo.setLayoutData(controlData);
	}

	@Override
	public void setObjectValues(ResourceType rt) {
			rt.setConnectionType(connTypesNameObjMap.get(connTypeCombo.getText()));
	}

	@Override
	public void clearControls() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void initValues() {
		IResourceTypeService rtService = ServiceFactory.createFactory().createResourceTypeService();
		List<ConnectionType> connTypes = rtService.getAllConnectionTypes();
		if (connTypes != null && !connTypes.isEmpty()) {
			connTypeCombo.removeAll();
			for (ConnectionType connType : connTypes) {
				connTypeCombo.add(connType.getName());
				connTypesNameObjMap.put(connType.getName(), connType);
			}
			connTypeCombo.select(0);
		}
	}

	@Override
	public String validate() {
		return null;
	}

	@Override
	public void setFormPartDirtyModifyListener(ModifyListener validationListener) {
		connTypeCombo.addModifyListener(validationListener);
	}

	@Override
	public void setCurrentValue(ResourceType resourceType) {
		ConnectionType connectionType = resourceType.getConnectionType();
		String value = (connectionType != null) ? connectionType.getName() : null;
		this.connTypeCombo.setText(this.formatValue(value, false));
	}
	
	/* Creates a blank string for null values, and trims if required */
	protected String formatValue(String value, boolean trim)
	{
		String newValue = null;

		if (value == null)
			newValue = "";
		else if (trim)
			newValue = value.trim();
		else
			newValue = value;

		return newValue;
	}

	@Override
	public void setWidgetPermission(boolean isEditable) {
		this.connTypeCombo.setEnabled(isEditable);
	}

}
