package com.tandbergtv.watchpoint.studio.ui.properties;

import java.util.List;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class AssignNodeCellModifier implements ICellModifier {

    private String[] columnNames;
    private List<WPVariable> variables;
    private TableViewer tableViewer;

    public AssignNodeCellModifier(TableViewer tableViewer, String[] columnNames) {
        this.tableViewer = tableViewer;
        this.columnNames = columnNames;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return true;
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnNames[0])) {
            if (variables == null) {
                return -1;
            }

            String stringValue = variable.getName();
            int i = variables.size() - 1;
            while (i > 0 && !stringValue.equals(variables.get(i).getName())) {
                --i;
            }
            return new Integer(i);
        }

        return variable.getValue();
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();

        if (property.equals(columnNames[0]) && ((Integer)value > -1)) {
            if (variables == null) {
                return;
            }

            Integer index = (Integer) value;
            WPVariable newWpVariable = variables.get(index);

            variable.setMappedName(newWpVariable.getMappedName());
            variable.setName(newWpVariable.getName());
            variable.setType(newWpVariable.getType());

        } else if (property.equals(columnNames[2])){
            variable.setValue((String) value);
        }

        tableViewer.update(variable, new String[] {property});
    }

    public void setVariables(List<WPVariable> variables) {
        this.variables = variables;
    }
}