package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;


public class LoopNodeDetailsSection extends AbstractPropertySection {
	
	private LoopNodeDetailsConfigurationComposite loopNodeDetailsConfigurationComposite;
	private LoopNode loopNode;
	
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        loopNodeDetailsConfigurationComposite = LoopNodeDetailsConfigurationComposite.create(this, getWidgetFactory(), clientArea);
    }
 
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
        	input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof LoopNode) {
        	setLoopNode((LoopNode)input);
        }
    }
 	
 	private void setLoopNode(LoopNode loopNode) {
 		this.loopNode = loopNode;
 	}

 	public void refresh() {
 		if (loopNode != null) {
 			loopNodeDetailsConfigurationComposite.setLoopNode(loopNode);
 		}
    }
 	
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
}