package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.ProcessState;

import com.tandbergtv.watchpoint.studio.service.impl.WorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ProcessStateSection extends AbstractPropertySection {

    private ProcessStateSectionComposite composite;
    private WorkflowTemplateService templateServ = new WorkflowTemplateService();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        composite = new ProcessStateSectionComposite(parent, getWidgetFactory());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (composite != null) {
            composite.setInput((ProcessState) Utility.getSemanticElement(selection), templateServ.getTemplateList(), Utility.getProjectFromEditor(editor));
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}