package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;

/**
 * Filter for elements which can have a resource type associated with them.
 * 
 * @author Imran Naqvi
 * 
 */
public class ResourceTypeFilter extends WPPropertyFilter {
	
	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		/* Resource type is allowed only for elements of type IResourceTypeElement */
		return modelElement instanceof IResourceTypeElement;
	}
}
