/*
 * Created on Aug 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IFilter;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.notation.JpdlNode;
import org.jbpm.gd.jpdl.notation.JpdlRootContainer;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * The Property Filter used to perform filtering on the Semantic Element contained in the object
 * being filtered.
 * 
 * @author Vijay Silva
 */
public abstract class WPPropertyFilter implements IFilter
{
	/*The container semantic element of the currently selected editPart. This is only set for nodes in the 
	 * graph and will be null for edges*/
	protected NodeElementContainer container;
	
	/**
	 * @see org.eclipse.jface.viewers.IFilter#select(java.lang.Object)
	 */
	public boolean select(Object toTest)
	{
		if(toTest instanceof EditPart){
			SemanticElement rootElement = null;
			Object modelObject = ((EditPart)toTest).getModel();
			if(modelObject instanceof JpdlNode)
				rootElement = ((JpdlNode) modelObject).getContainer().getSemanticElement();
			else if (modelObject instanceof JpdlRootContainer)
				rootElement = ((JpdlRootContainer) modelObject).getSemanticElement();
			
			if(rootElement != null && rootElement instanceof NodeElementContainer)
				container = (NodeElementContainer) rootElement;
		}
		SemanticElement modelElement = this.getModelElement(toTest);
		return this.selectModelElement(modelElement);
	}

	/**
	 * The Model Element to test for filtering.
	 * 
	 * @param modelElement
	 *            The Model Semantic Element
	 * 
	 * @return true if the filter is passed, false otherwise.
	 */
	protected abstract boolean selectModelElement(SemanticElement modelElement);

	/**
	 * Get the Model Element contained in the object
	 * 
	 * @param toTest
	 *            The object to filter
	 * 
	 * @return The Model Semantic Element contained in the filtered object, or null if no object is
	 *         present, or if the contained model element is not a Semantic Element.
	 */
	protected SemanticElement getModelElement(Object toTest)
	{
		return (toTest instanceof EditPart)
				? Utility.getSemanticElement((EditPart) toTest) : null;
	}
}
