/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * This section is responsible for showing the constants in a node definition message.
 * 
 * @author Imran Naqvi
 * 
 */
public class ConstantsSection extends AbstractPropertySection {
	
	private IMessageNodeContainer messageContainer;

	private ConstantsComposite constantsComposite;

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
		
		constantsComposite = ConstantsComposite.create(getWidgetFactory(), clientArea);
		
		clientArea.layout();
		clientArea.pack();
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		if (!(selection instanceof IStructuredSelection))
			return;

		SemanticElement element = Utility.getSemanticElement(selection);

		if (element instanceof IMessageNodeContainer) {
			messageContainer = (IMessageNodeContainer) element;
			refresh();
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
	 */
	public void refresh() {
		if (constantsComposite == null)
			return;
		constantsComposite.setMessageNodeContainer(this.messageContainer);
	}
}
