/**
 * AbstractDiffCommand.java
 * Created Apr 14, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.command;

import com.tandbergtv.watchpoint.studio.ui.command.AbstractCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * A command that applies a diff. Subclasses should contain the model objects that will change. The
 * sync context associated with the command must be used to perform updates to the local repository.
 * Subclasses must not call begin() or end() on the context.
 * 
 * @author Sahil Verma
 */
public abstract class AbstractDiffCommand extends AbstractCommand {
	
	protected IDiff diff;
	
	protected ISynchronizationContext context;

	/**
	 * @param name
	 * @param description
	 */
	protected AbstractDiffCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, null, true);
		this.diff = diff;
		this.context = context;
	}
	
	/**
	 * @param name
	 * @param description
	 */
	protected AbstractDiffCommand() {
	}

	/**
	 * @return the diff
	 */
	public IDiff getDiff() {
		return diff;
	}
}
