/**
 * RemoveNodeCommand.java
 * Created Apr 20, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Removes an existing node definition
 * 
 * @author Sahil Verma
 */
public class RemoveNodeCommand extends AbstractDiffCommand {

	private NodeDefinitionDTO model;
	
	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public RemoveNodeCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		this.model = (NodeDefinitionDTO) diff.getModel();
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		context.deleteNode(model);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Node " + model.getName() + " " + diff.getKind();
	}
}
