/**
 * UpdateVariableCommand.java
 * Created May 10, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.template;

import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Updates a variable's properties (access, data type) wherever it occurs in a node of a template
 * 
 * @author Sahil Verma
 */
public class UpdateVariableCommand extends AbstractVariableCommand {
	
	protected NodeDefinition node;
	
	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public UpdateVariableCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * @return the node
	 */
	public NodeDefinition getNode() {
		return node;
	}

	/**
	 * @param node the node to set
	 */
	public void setNode(NodeDefinition node) {
		this.node = node;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void execute() {
		WorkflowTemplate template = (WorkflowTemplate) container;
		
		for (NodeElement element : template.findNodes(this.node.getId())) {
			NodeDefinition node = (NodeDefinition) element;
			
			updateVariable(node);
		}
	}
	
	protected void updateVariable(NodeDefinition node) {
		for (WPVariable v : node.getVariables()) {
			if (v.getMappedName().equals(this.variable.getMappedName())) {
				v.setAccess(this.variable.getAccess());
				v.setType(this.variable.getType());
				break;
			}
		}
	}
}
