/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.util;

import java.io.IOException;
import java.util.Properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;

/**
 * Loads service error messages from a properties file.
 * 
 * @author Imran Naqvi
 * 
 */
public class ServiceErrors extends Properties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 9169046859311916211L;

	private static final String RESOURCE_PATH = "/ServiceErrors.properties";

	// Singleton Instance
	private static ServiceErrors instance;

	private ServiceErrors() {
		super();
		this.loadProperties();
	}

	/**
	 * Singleton Accessor.
	 * 
	 * @return The Properties singleton instance
	 */
	public static synchronized ServiceErrors getInstance() {
		if (instance == null) {
			instance = new ServiceErrors();
		}

		return instance;
	}

	/*
	 * Initialize the Properties by loading the values from the Service Errors Properties file.
	 */
	private void loadProperties() {
		try {
			this.load(this.getClass().getResourceAsStream(RESOURCE_PATH));
		}
		catch (IOException e) {
			throw new UIException("Could not read from service error properties file at location "
					+ RESOURCE_PATH, e);
		}
	}
}
