package com.tandbergtv.watchpoint.studio.ui.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class ResourceTypeMessageDialog extends ResourceTypeMessageReferencesTreeBase {
	private String name;
	private String datatype;
	private String constant;
	private String description;
	private boolean composite;
	private boolean outgoing = true;
	private Text nameField;
	private Text constantField;
	private Text descriptionField;
	private Button compButton;
	private Button inoutButton;
	private Button consButton;
	private Label descLabel;
	private CCombo datatypeCombo;
	private boolean OKButtonenabled = true;
	private boolean isSuperstate = false;
	private String referenceMessage;
	
	private boolean addMode = false;
	private boolean modifyConstantMode = false;
	private boolean modifyVariableMode = false;
	private boolean modifyCompKeyMode = false;
	private boolean consButtonSelection = false;
	
	public ResourceTypeMessageDialog (Shell parentShell) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		final GridLayout gridLayout = new GridLayout();
		container.setLayout(gridLayout); 
		gridLayout.numColumns = 2;

		final Label nameLabel = new Label(container, SWT.NONE);
		nameLabel.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false));
		nameLabel.setText("Name:");

		nameField = new Text(container, SWT.BORDER);
		nameField.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));
		nameField.setText((name != null)?name:"");
		
		final Label datatypeLabel = new Label(container, SWT.NONE);
		final GridData gridData = new GridData(GridData.END, GridData.CENTER, false, false);
		datatypeLabel.setLayoutData(gridData);
		datatypeLabel.setText("Data Type:");

		datatypeCombo = new CCombo(container, SWT.BORDER);
		datatypeCombo.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));
		int selected = (datatype != null)?DataType.valueOf(datatype).ordinal() : DataType.STRING.ordinal();
		String[] items = new String[DataType.values().length];
		int i = 0;
		for (DataType item: DataType.values()) {
			items[i] = item.name();
			i++;
		}
		datatypeCombo.setItems(items);
		datatypeCombo.select(selected);
		datatypeCombo.setEditable(false);
		final Composite checkbox = new Composite(container, SWT.NONE);
		final GridData gridD = new GridData(GridData.FILL, GridData.FILL, false, false, 2, 1);
		gridD.horizontalIndent = 20;
		checkbox.setLayoutData(gridD);
		final GridLayout checkboxLayout = new GridLayout();
		checkboxLayout.numColumns = 2;
		checkbox.setLayout(checkboxLayout);
		
		inoutButton = new Button(checkbox,SWT.CHECK);
		inoutButton.setText("Outgoing");
		inoutButton.setSelection(outgoing);
		inoutButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				handleInoutButton();
			}
		});
		
		compButton = new Button(checkbox,SWT.CHECK);
		compButton.setText("Composite Key");
		compButton.setEnabled(outgoing ? false:true);
		compButton.setSelection(composite);
		compButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				handleCompositeButton();
			}
		});
		
		
		consButton = new Button(checkbox,SWT.CHECK);
		consButton.setText("Constant:");
		consButton.setSelection((constant != null)&&(!"".equals(constant))?true:false);
		consButton.setEnabled(inoutButton.getSelection());
		consButton.addListener(SWT.Selection, new Listener(){
			public void handleEvent(Event event){
				handleConstantButton();
			}
		});
		constantField = new Text(checkbox, SWT.BORDER);
		constantField.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));
		constantField.setText((constant != null)?constant:"");
		constantField.setEnabled((constant != null)&&(!"".equals(constant))?true:false);
		
		descLabel = new Label(container, SWT.NONE);
		descLabel.setText("Description :");
		descLabel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false, 2, 0));
		descriptionField = new Text(container, SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		descriptionField.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, true, 2, 0));
		descriptionField.setEditable(true);
		descriptionField.setText((description != null)? description:"");
		
		/* Creates references tree UI widgets */
		super.createControls(container);
		
		if(referenceMessage != null && !referenceMessage.equals("")){
			Label messageLabel = new Label(container, SWT.NONE);
			messageLabel.setText(referenceMessage);
			messageLabel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false, 2, 0));
		}
	    
		//if the dialog was open for a superstate editing, disable the controls below
		if(isSuperstate){
			compButton.setEnabled(false);
			consButton.setEnabled(false);
			constantField.setEnabled(false);
			inoutButton.setEnabled(false);
		}
		
		if(addMode){
			compButton.setEnabled(false);
		}
		if(modifyVariableMode){
			compButton.setEnabled(false);
			inoutButton.setEnabled(false);
		}
		if(modifyConstantMode){
			compButton.setEnabled(false);
			inoutButton.setEnabled(false);
			consButton.setEnabled(false);
			datatypeCombo.select(DataType.STRING.ordinal());
			datatypeCombo.setEnabled(false);
		}
		if(modifyCompKeyMode){
			consButton.setEnabled(false);
			datatypeCombo.setEnabled(false);
		}
		
		return container;
	}
	
	protected void setDialogSize(){
		
	}
	
	private void handleInoutButton(){
		compButton.setEnabled(!compButton.getEnabled());
		compButton.setSelection(false);
		consButton.setEnabled(true);
		consButton.setSelection(false);

		constantField.setEnabled(consButton.getSelection());
		if (consButton.getSelection() == false) {
			constantField.setText("");
		}
	}
	
	private void handleConstantButton(){
		constantField.setEnabled(consButton.getSelection());
		if(consButton.getSelection() == false){
			constantField.setText("");
			datatypeCombo.setEnabled(true);
		}else{
			datatypeCombo.select(DataType.STRING.ordinal());
			datatypeCombo.setEnabled(false);
		}
		inoutButton.setSelection(true);
		compButton.setSelection(false);
		compButton.setEnabled(false);
	}
	
	private void handleCompositeButton(){
		consButton.setEnabled(!compButton.getSelection());
		consButton.setSelection(false);
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		// Create Preview button
	    Button previewButton = createButton(parent, 10, "Preview", false);
	    previewButton.setEnabled(OKButtonenabled);
	    // Add a SelectionListener
	    previewButton.addSelectionListener(new SelectionAdapter() {
	    	@Override
	      public void widgetSelected(SelectionEvent e) {
	    	  showReferencesTree();
	      }
	    });

	    // Create OK button
	    Button okButton = createButton(parent, OK, "OK", true);
	    okButton.setEnabled(OKButtonenabled);
	    // Add a SelectionListener
	    okButton.addSelectionListener(new SelectionAdapter() {
	    	@Override
	      public void widgetSelected(SelectionEvent e) {
	    	  setReturnCode(OK);
		        close();
	      }
	    });

	    // Create Cancel button
	    Button cancelButton = createButton(parent, CANCEL, "Cancel", false);
	    // Add a SelectionListener
	    cancelButton.addSelectionListener(new SelectionAdapter() {
	    	@Override
	      public void widgetSelected(SelectionEvent e) {
	        setReturnCode(CANCEL);
	        close();
	      }
	    });
	}

	@Override
	protected void configureShell(Shell newshell) {
		  super.configureShell(newshell);
		  newshell.setLocation(150, 150);
		  newshell.setSize(700, 450);
		  newshell.setText("Message Parameter Dialog");
	}

	@Override
	protected void okPressed()
	{
		this.name = this.nameField.getText().trim();
		this.datatype = this.datatypeCombo.getText();
		this.description = this.descriptionField.getText();
		this.constant = this.constantField.getText();
		this.composite = this.compButton.getSelection();
		this.outgoing = this.inoutButton.getSelection();
		this.consButtonSelection = this.consButton.getSelection();
		
		this.updateReferences = updateReferencesButton.getSelection();
		super.fillAffectedMessages();
		
		super.okPressed();
	}

	public boolean getConsButtonSelection(){
		return consButtonSelection;
	}
	  
	public void setModifyConstantMode(boolean value){
		this.modifyConstantMode = value;
	}
	
	public void setModifyCompKeyMode(boolean value){
		this.modifyCompKeyMode = value;
	}
	
	public void setModifyVariableMode(boolean value){
		this.modifyVariableMode = value;
	}
	
	public void setAddMode(boolean value){
		this.addMode = value;
	}
	
	public String getName() {
		  return name;
	}

	public String getDatatype() {
		  return datatype;
	}
	  
	public String getConstant() {
		  return constant;
	}
	  
	public void setName(String name) {
		  this.name = name;
	}

	public void setDatatype(String datatype) {
		  this.datatype = datatype;
	}
	  
	public void setConstant(String constant) {
		  this.constant = constant;
	}

	public boolean isOutgoing () {
		  return this.outgoing ;
	}
	  
	public boolean isComposite() {
		  return this.composite;
	}
	  
	public void setOutgoing(boolean outgoing ) {
		  this.outgoing  = outgoing;
	}
	  
	public void setComposite(boolean composite) {
		  this.composite = composite;
	}
	  
	public void setDescription(String description) {
		  this.description = description;
	}
	  
	public String getDescription() {
		  return description;
	}
	  	  
	public Point getInitialSize() {
		  return new Point(300,350);
	}
	
	public void setOKButtonEnabled(boolean enabled) {
			OKButtonenabled = enabled;
	}
	
	public void setReferenceMessage(String referenceMessage) {
		this.referenceMessage = referenceMessage;
	}

	public String getReferenceMessage() {
		return referenceMessage;
	}

	public boolean isSuperstate() {
		return isSuperstate;
	}

	public void setSuperstate(boolean isSuperstate) {
		this.isSuperstate = isSuperstate;
	}

}
