package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import static org.eclipse.jface.dialogs.MessageDialog.openConfirm;
import static org.eclipse.swt.widgets.Display.getCurrent;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.ReferenceDeletionException;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;

public class DeleteSuperStateAction extends AbstractNodeDefinitionAction{
	private NodeDefinitionDTO nodeDefinitionDTO;
	
	@Override
	public void run(IAction action) {
		run();
	}
	
	public void run(NodeDefinitionDTO nodeDefinition) {
		this.nodeDefinitionDTO = nodeDefinition;
		run();
	}
	
	public void run() {
		INodeDefinitionService service = ServiceFactory.createFactory().createNodeDefinitionService();
		
		try {
			String msg = "Are you sure you want to delete '" + nodeDefinitionDTO.getName() + "'?";
			boolean response = openConfirm(getCurrent().getActiveShell(), "Confirm Delete", msg);

			if (response == false)
				return;
			
			NodeDefinitionDTO nodeDTO = service.getNodeDefinitionDTOByPath(nodeDefinitionDTO.getPath());
			
			service.deleteNodeDefinitionInFileSystem(nodeDTO, false);
		} catch (ReferenceDeletionException e) {
			String emsg = buildReferenceDeletionErrorMsg(e.getReferences());

			if (!openConfirm(getCurrent().getActiveShell(), "Remove References?", emsg))
				return;
			
			NodeDefinitionDTO nodeDTO = service.getNodeDefinitionDTOByPath(nodeDefinitionDTO.getPath());
			service.deleteNodeDefinitionInFileSystem(nodeDTO, true);
		} catch (ServiceException e) {
			handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
		} 
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (!selection.isEmpty()) {
			// Gets the Node Definition
			Object element = ((TreeSelection) selection).getFirstElement();
			
			if (element instanceof NodeDefinitionDTO) {
				this.nodeDefinitionDTO = (NodeDefinitionDTO) element;
			}
		}
	}
	
}
