package com.tandbergtv.watchpoint.studio.ui.wizard;

import static java.io.File.separator;

import java.util.Map;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;

/**
 * 
 * @author Raj Prakash
 *
 */
public class ResourceGroupExportWizard extends WPDTOExportWizard<ResourceGroup> {

	private static final String TITLE = "Export Resource Group";
	
	private static final String SUFFIX = "plugins" + separator + "groups" + separator;
	
	public ResourceGroupExportWizard(ResourceGroup group) {
		super(group, group.getSystemId() + " resource group", SUFFIX + group.getName(), TITLE);
	}

	@Override
	protected void export(ResourceGroup dtoObject, Map<String, Object> exportInputAttrs)
																throws ExportFailureException {
		ServiceFactory.createFactory().createResourceGroupService()
			.exportResourceGroup(dtoObject, exportInputAttrs);
	}
}
