package com.tandbergtv.watchpoint.studio.ui.wizard;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.RESOURCE_TYPE_BUILD_FILE_NAME;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.RESOURCE_TYPE_BUILD_PROPERTIES_FILENAME;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.RESOURCE_TYPE_PLUGIN_FILE_NAME;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.jbpm.gd.jpdl.wizard.ResourceTypeJavaProjectCreatorCustom;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.tandbergtv.watchpoint.studio.builder.WatchpointResourceTypeNature;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.wizard.resourcegroup.NewResourceGroupWizard;
import com.tandbergtv.watchpoint.studio.util.PluginFileGenerationException;
import com.tandbergtv.watchpoint.studio.util.ResourceTypePluginFileGenerator;
import com.tandbergtv.watchpoint.studio.util.XMLDocumentUtility;

public class ResourceTypeJavaProjectCreator extends ResourceTypeJavaProjectCreatorCustom{
	private ResourceType resourceType;
	
	public ResourceTypeJavaProjectCreator(ResourceType resourceType, String projectName, String locationPath) {
		super(projectName, locationPath);
		this.resourceType = resourceType;
	}


	@Override
	public void createInitialContent(IJavaProject javaProject) throws TransformerException, ParserConfigurationException, IOException, CoreException {
		createFolders(javaProject);
		try {
			copyBuildFiles(javaProject);
			copyPluginFile(javaProject);
			createDefaultResourceGroup(javaProject);
		} catch (Exception e) {
//			handleProjectException( "Resource Type Creation Failed.", e );
		}
	}
	
	/*
	 * 	Creates the default ResourceGroup with the same name as the ResourceType
	 */
	@Override
	public void createDefaultResourceGroup(IJavaProject javaProject) throws CoreException {
		NewResourceGroupWizard.createResourceGroup(javaProject.getProject().getFolder("groups"), 
				resourceType.getName(), resourceType.getSystemId());
	}

	private void copyPluginFile(IJavaProject javaProject) throws PluginFileGenerationException, CoreException {
		// Copy plugin.xml
		Document pluginFile = ResourceTypePluginFileGenerator.generatePluginDocument(resourceType);
		File pluginSourcePath = javaProject.getProject().getLocation().toFile();
		ByteArrayOutputStream plugin = ResourceTypePluginFileGenerator.createWritablePluginDocument(pluginFile, pluginSourcePath);
		byte[] pluginContentArray = plugin.toByteArray();
		createProjectFileFromInputStream(javaProject, RESOURCE_TYPE_PLUGIN_FILE_NAME, new ByteArrayInputStream(pluginContentArray));
	}

	@Override
	public void copyBuildFiles(IJavaProject javaProject) throws Exception {
		// Copy build.xml
		InputStream buildFile = this.getClass().getResourceAsStream(RESOURCE_TYPE_BUILD_FILE_NAME);
		Document buildDocument = XMLDocumentUtility.loadFile(buildFile, false);
		String projectName = javaProject.getProject().getName();
		changeBuildAttributeValue(buildDocument, "project", "name", projectName);
		ByteArrayOutputStream baos = XMLDocumentUtility.createByteArray(buildDocument);
		byte[] buildContentArray = baos.toByteArray();
		createProjectFileFromInputStream(javaProject, RESOURCE_TYPE_BUILD_FILE_NAME, new ByteArrayInputStream(buildContentArray));

		// Copy build.properties
		Properties prop = new Properties();
		prop.load(this.getClass().getResourceAsStream(RESOURCE_TYPE_BUILD_PROPERTIES_FILENAME));
		prop.put("project.name", javaProject.getProject().getName());
		ByteArrayOutputStream propFile = new ByteArrayOutputStream();
		prop.store(propFile, "Properties for the Resource Type build.xml");
		byte[] fileContentArray = propFile.toByteArray();
		createProjectFileFromInputStream(javaProject, RESOURCE_TYPE_BUILD_PROPERTIES_FILENAME, new ByteArrayInputStream(fileContentArray));
	}
	
	/**
	 * This method change the value of a given attribute in a given element in a given document.<br>
	 * This method assume that the given element occur just once in the given document.
	 * @param doc The Document object
	 * @param element The name of the element to be changed
	 * @param attribute The attribute to be changed
	 * @param value The new attribute value
	 */
	private void changeBuildAttributeValue(Document doc, String element, String attribute, String value){
		NodeList elements = doc.getElementsByTagName(element);
		elements.item(0).getAttributes().getNamedItem(attribute).setNodeValue(value);
	}
	



	@Override
	public void addNature(IProject project) throws CoreException {
		IProjectDescription description = project.getDescription();
		String[] natures = description.getNatureIds();

		// Add the nature
		String[] newNatures = new String[natures.length + 1];
		System.arraycopy(natures, 0, newNatures, 0, natures.length);
		newNatures[natures.length] = WatchpointResourceTypeNature.NATURE_ID;
		description.setNatureIds(newNatures);
		project.setDescription(description, null);
	}


}
