package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.MailNode;

public class MailNodeDomAdapter extends org.jbpm.gd.jpdl.xml.MailNodeDomAdapter {

	@Override
	protected void initialize() {
		super.initialize();
		MailNode mailNode = (MailNode)getSemanticElement();
		if (mailNode != null) {
			setAttribute("attachment", mailNode.getAttachment());
		}
	}
	
	@Override
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		MailNode mailNode = (MailNode)jpdlElement;
		mailNode.setAttachment(getAttribute("attachment"));
	}
	
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		if ("attachment".equals(evt.getPropertyName())) {
			setAttribute("attachment", (String)evt.getNewValue());
		}
	}
	
	@Override
	protected void doModelUpdate(String name, String newValue) {
		super.doModelUpdate(name, newValue);
		MailNode mailNode = (MailNode)getSemanticElement();
		if ("attachment".equals(name)) {
			mailNode.setAttachment(newValue);
		} 
	}
	
}
