/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.xml.SuperStateDomAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;

/**
 * The Dom Adaptor class for a node group.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeGroupDomAdapter extends SuperStateDomAdapter {

	private static Map<String, String> NODE_TYPES = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.SuperStateDomAdapter#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if ("resourceGroupAdd".equals(evt.getPropertyName())) {
			addElement((SemanticElement) evt.getNewValue());
		}
		else
			super.propertyChange(evt);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#getNodeTypes()
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected Map<String, String> getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = super.getNodeTypes();
			NODE_TYPES.put("loop", "node-element");
			
			NODE_TYPES.put("nodeDefinition", "node-element");
			NODE_TYPES.put("auto-task", "node-element");
			NODE_TYPES.put("resource-group", "resource-group");
		}
		return NODE_TYPES;
	}
	
	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.SuperStateDomAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		super.initialize();
		if (getSemanticElement() != null) {
			NodeGroup superState = (NodeGroup) getSemanticElement();
			addElement(superState.getResourceGroup());
		}
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.SuperStateDomAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		String type = child.getElementType();
		SemanticElement jpdlElement = createSemanticElementFor(child);
		child.initialize(jpdlElement);
		NodeGroup superState = (NodeGroup) getSemanticElement();
		if ("auto-task".equals(type) || "nodeDefinition".equals(type) || "loop".equals(type)) {
			superState.addNodeElement((NodeElement) jpdlElement);
		}
		else if ("resource-group".equals(type)) {
			child.initialize(jpdlElement);
			superState.setResourceGroup((ResourceGroup) jpdlElement);
		}
		else
			super.doModelAdd(child);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.SuperStateDomAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		String type = child.getElementType();
		NodeGroup superState = (NodeGroup) getSemanticElement();
		if ("auto-task".equals(type) || "nodeDefinition".equals(type) || "loop".equals(type)) {
			superState.removeNodeElement((NodeElement) child.getSemanticElement());
		}
		else if ("resource-group".equals(type)) {
			superState.setResourceGroup(null);
		}
		else
			super.doModelRemove(child);
	}
}
