/**
 * 
 */
package com.tandbergtv.watchpoint.studio.usermgmt;

/**
 * Exception indicating that there was an error in the User Management when creating a User or
 * generating the User Id.
 * 
 * @author DReddy
 * 
 */
public class UserManagementException extends Exception {

	private static final long serialVersionUID = -6552339640558056748L;

	/**
	 * Default Constructor
	 */
	public UserManagementException() {
	}

	/**
	 * @param msg
	 *            The detail message
	 */
	public UserManagementException(String msg) {
		super(msg);
	}

	/**
	 * @param reason
	 *            The reason for this exception
	 */
	public UserManagementException(Throwable reason) {
		super(reason);
	}

	/**
	 * @param msg
	 *            The detail message
	 * @param reason
	 *            The reason for this exception
	 */
	public UserManagementException(String msg, Throwable reason) {
		super(msg, reason);
	}
}
