/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.model;

import java.util.List;

import org.jbpm.gd.jpdl.model.Decision;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * Validation Model Object that represents a Decision Expression.
 * 
 * @author DReddy
 * @author Vijay Silva
 */
public class DecisionExpression extends ContainerValidationContext
{
	protected Decision decision;

	/**
	 * Constructor.
	 * 
	 * @param template
	 *            the workflow template that contains the decision node
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param decision
	 *            the decision node with the expression to validate
	 */
	public DecisionExpression(WorkflowTemplate template, List<WPVariable> variables,
			Decision decision)
	{
		super(template, variables);
		this.decision = decision;
	}

	/**
	 * Constructor.
	 * 
	 * @param nodeDefinition
	 *            the node definition that contains the decision node
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param decision
	 *            the decision node with the expression to validate
	 */
	public DecisionExpression(NodeDefinition nodeDefinition, List<WPVariable> variables,
			Decision decision)
	{
		super(nodeDefinition, variables);
		this.decision = decision;
	}

	/**
	 * Get the Decision node
	 * 
	 * @return the decision
	 */
	public Decision getDecision()
	{
		return this.decision;
	}
}
