/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation rule that verifies that a IResourceGroupElement does not have a Resource Group
 * defined.
 * 
 * @author Vijay Silva
 */
public class ResourceGroupAbsentRule extends ValidationRule<IResourceGroupElement>
{
	/**
	 * Check that a IResourceGroupElement does not have a Resource Group defined.
	 * 
	 * @param target
	 *            The IResourceGroupElement to validate
	 * 
	 * @return The List of validation messages
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(IResourceGroupElement target)
	{
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        if (target.getResourceGroup() != null) {
            ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.NODE_RESOURCEGROUP_DEFINED);
        }

		return messages;
	}
}
