package com.tandbergtv.watchpoint.studio.debugger.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.debugger.util.Base64Encoder;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class NodeBreakpoint extends Breakpoint {

    protected static final String NODE_NAME = "nodeName";

    /**
     * Default constructor is required for the breakpoint manager
     * to re-create persisted breakpoints. After instantiating a breakpoint,
     * the <code>setMarker(...)</code> method is called to restore
     * this breakpoint's attributes.
     */
    public NodeBreakpoint() {
    }

    public NodeBreakpoint(final IResource resource, final String node)
            throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable() {
            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource
                        .createMarker("com.tandbergtv.watchpoint.studio.debugger.nodeBreakpoint.marker");
                setMarker(marker);
                marker.setAttribute(IBreakpoint.ENABLED, Boolean.TRUE);
                marker.setAttribute(NodeBreakpoint.NODE_NAME, node);
                marker.setAttribute(IBreakpoint.ID, getModelIdentifier());
            }
        };
        run(getMarkerRule(resource), runnable);
    }

    /* (non-Javadoc)
     * @see org.eclipse.debug.core.model.IBreakpoint#getModelIdentifier()
     */
    public String getModelIdentifier() {
        return TemplateLauncherConstants.ID_JPDL_DEBUG_MODEL;
    }

    public String getNodeName() {
        try {
            return (String) getMarker().getAttribute(NodeBreakpoint.NODE_NAME);
        } catch (CoreException e) {
            return null;
        }
    }
    
    public String getResourceName() {
        return getMarker().getResource().getName();
    }

    public String serializeNodeName() {
        String originalNodeName = getNodeName();
        return Base64Encoder.encode(originalNodeName);
    }

    public boolean canBeAdded() {
        // if debug process is not running
        if ((JpdlDebugTarget.getInstance() == null || JpdlDebugTarget.getInstance().isTerminated()) /*&& !isBreakpointSetInOtherForkPath() */) {
            return true;
        }

        return false;
    }

/* this method is throwing VerifyException because of a jdk bug: http://bugs.sun.com/bugdatabase/view_bug.do;jsessionid=eb3fcd8f72ab4713f96e378a7575?bug_id=6614974
     private boolean isBreakpointSetInOtherForkPath() {
        WatchPointTemplateEditor editor = (WatchPointTemplateEditor) Utility.getEditor(Utility.TEMPLATE_EDITOR_ID,
                getMarker().getResource());
        for (Fork fork : Utility.getForkNodes(editor)) {
            if (Utility.isNodeInForkPaths(editor, fork, null, getNodeName())) {
                for (Transition transition : fork.getTransitions()) {
                    if (!Utility.isNodeInForkPath(editor, transition, getNodeName())) {
                        if (Utility.forkPathHasBreakpoint(editor, transition, editor.getEditorInput())) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
*/
    public boolean canBeRemoved() {
        // if debug process is not running
        if (JpdlDebugTarget.getInstance() == null || JpdlDebugTarget.getInstance().isTerminated()) {
            return true;
        }
        return false;
    }
}