package com.tandbergtv.watchpoint.studio.debugger.runtime.output;

import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;

import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;

/**
 * 		Writes the output of the Template simulation.
 *  
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public abstract class TemplateSimulationOutputWriter {

	public abstract void templateSimulationStarted(ExecutionContext context, ProcessDefinition template);
	
	public abstract void templateSimulationCompleted(ExecutionContext context, ProcessDefinition template);
	
	public abstract void nodeSimulationStarted(ExecutionContext context, Node node, NodeSimulator simulator);
	
	public abstract void nodeSimulationCompleted(ExecutionContext context, Node node, NodeSimulator simulator);
}
