/**
 * ActionDelegation.java
 * Created Nov 12, 2007
 * Copyright (c) TANDBERG Television 2007
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.template;

import static org.apache.log4j.Logger.getLogger;

import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.Instantiator;

/**
 * A simple decorator for a JBPM Delegation that allows class loading from classpath
 * 
 * @author Sahil Verma
 */
public class ActionDelegation extends Delegation {

	private static final long serialVersionUID = -3710048187930219871L;

	private Delegation delegation;
	
	/**
	 * Creates a nActionDelegation
	 */
	public ActionDelegation() {
		super();
		this.delegation = new Delegation();
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#setClassName(java.lang.String)
	 */
	@Override
	public void setClassName(String className) {
		this.delegation.setClassName(className);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#setConfigType(java.lang.String)
	 */
	@Override
	public void setConfigType(String instantiatorType) {
		this.delegation.setConfigType(instantiatorType);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#setConfiguration(java.lang.String)
	 */
	@Override
	public void setConfiguration(String configuration) {
		this.delegation.setConfiguration(configuration);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#setId(long)
	 */
	@Override
	public void setId(long id) {
		this.delegation.setId(id);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#setProcessDefinition(org.jbpm.graph.def.ProcessDefinition)
	 */
	@Override
	public void setProcessDefinition(ProcessDefinition processDefinition) {
		this.delegation.setProcessDefinition(processDefinition);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.instantiation.Delegation#instantiate()
	 */
	public Object instantiate() {
		Object instance = null;
		Class<?> clazz = null;
		
		try {
			ClassLoader classLoader = getClass().getClassLoader();
			
			clazz = classLoader.loadClass(delegation.getClassName());
		} catch (ClassNotFoundException e) {
			getLogger(ActionDelegation.class).warn("Cannot load class " + delegation.getClassName());
			return new NoOp();
		}
		
		Instantiator instantiator = (Instantiator) Delegation.instantiatorCache.get(delegation.getConfigType());
		instance = instantiator.instantiate(clazz, delegation.getConfiguration());

		return instance;
	}
}
