package com.tandbergtv.watchpoint.studio.debugger.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Node;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.graph.def.ProcessDefinition;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.Loop;

public class NodeSimulationConfigFactory {

	private Set<Class<?>> simullableNodes;
	
	private static NodeSimulationConfigFactory instance;
	
	private NodeSimulationConfigFactory() {
		
	};
	@SuppressWarnings({ "rawtypes", "unchecked" })
	protected static Map<String, Map> createSimulationDataMapPerNode(Map globalAttributes) {
		Map<String, Map> attributesPerNode = new HashMap<String, Map>();
		for (Object keyObj : globalAttributes.keySet()) {
			String key = keyObj.toString();
			if (key.startsWith(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_DATA_PREFIX)) {
				int simulationDataIndex = key.indexOf(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA);
				if (simulationDataIndex > 0) {
					String nodeName = key.substring(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_DATA_PREFIX.length() + 1,
													simulationDataIndex - 1);
					Map nodeAttributes = attributesPerNode.get(nodeName);
					if (nodeAttributes == null) {
						nodeAttributes = new HashMap();
					}
					String attributeName = key.substring(simulationDataIndex + TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA.length() + 1, 
														 key.length());
					nodeAttributes.put(attributeName, globalAttributes.get(keyObj));
					attributesPerNode.put(nodeName, nodeAttributes);
				}
			}
		}
		return attributesPerNode;
	}
	
	public Set<Class<?>> getSimullableNodes() {
		if (simullableNodes == null) {
			simullableNodes = new HashSet<Class<?>>();
			simullableNodes.add(Node.class);
			simullableNodes.add(ProcessState.class);
			simullableNodes.add(SuperState.class);
			simullableNodes.add(Decision.class);
			simullableNodes.add(NodeDefinition.class);
			simullableNodes.add(AutomaticTaskNode.class);
			simullableNodes.add(ManualTaskNode.class);
			simullableNodes.add(LoopNode.class);
			simullableNodes.add(MailNode.class);
		}
		return simullableNodes;
	}
	
	public static NodeSimulationConfigFactory createFactory() {
		if (instance == null) {
			instance = new NodeSimulationConfigFactory();
		}
		return instance;
	}
	/**
	 * 		Gets the Nodes that can be simulated.
	 * 
	 * @param template
	 * @return
	 */
	@SuppressWarnings({ "rawtypes" })
	public Map<String, NodeSimulationConfig> getNodesForSimulation(WorkflowTemplate template, Map globalAttributes) {
		Map<String, NodeSimulationConfig> simulationConfigMap = new HashMap<String, NodeSimulationConfig>();
		Map<String, Map> attributesPerNode = createSimulationDataMapPerNode(globalAttributes);
		
		loadNodeSimulationConfig(template, attributesPerNode, globalAttributes, simulationConfigMap);
		
		return simulationConfigMap;
	}
	
	@SuppressWarnings({ "rawtypes" })
	public void loadNodeSimulationConfig(NodeElementContainer container, Map<String, Map> attributesPerNode, Map globalAttributes, Map<String, NodeSimulationConfig> simulationConfigMap) {
		NodeElement[] nodeElements = container.getNodeElements();
		for (NodeElement nodeElement : nodeElements) {
			if (getSimullableNodes().contains(nodeElement.getClass())) {
				NodeSimulationConfig config = getNodeForSimulation(nodeElement, globalAttributes, attributesPerNode);
				simulationConfigMap.put(nodeElement.getName(), config);
				if (nodeElement instanceof LoopNode) {
					loadNodeSimulationConfig((LoopNode) nodeElement, attributesPerNode, globalAttributes, simulationConfigMap);
				}
			}
		}
	}
	
	
	
	@SuppressWarnings({ "rawtypes" })
	public NodeSimulationConfig getNodeForSimulation(NodeElement nodeElement, Map globalAttributes, Map<String, Map> attributesPerNode) {
		NodeSimulationConfig config = getNodeForSimulation(nodeElement.getName(), globalAttributes, attributesPerNode);
		config.setNodeElement(nodeElement);
		if (config.getSimulationType() == null) {
			config.setSimulationType(getDefaultSimulationTypeForNode(nodeElement));
		}
		return config;
	}
	
	@SuppressWarnings({ "rawtypes" })
	public NodeSimulationConfig getNodeForSimulation(String nodeName, Map globalAttributes, Map<String, Map> attributesPerNode) {
		if (attributesPerNode == null) {
			attributesPerNode = createSimulationDataMapPerNode(globalAttributes);
		}
		NodeSimulationConfig config = new NodeSimulationConfig();
		SimulationData simulationData = new SimulationData(attributesPerNode.get(nodeName));

		config.setTemplateNodeName(nodeName);
		config.setSimulationData(simulationData);
        config.setTemplatePath((String) globalAttributes.get(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_DATA_TEMPLATE));
		String simulationType = (String) globalAttributes.get(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName));
		if (simulationType != null && !simulationType.trim().isEmpty()) {
			config.setSimulationType(SimulationType.valueOf(simulationType));
		}
		
		return config;
	}
	
	protected SimulationType getDefaultSimulationTypeForNode(NodeElement node) {
		SimulationType result = null;
		if (node instanceof Decision) {
			result = SimulationType.EXECUTE;
		} else {
			result = SimulationType.SKIP_NODE;
		}
		
		return result;
	}
	
	protected SimulationType getDefaultSimulationTypeForNode(org.jbpm.graph.def.Node node) {
		SimulationType result = null;
		if (node instanceof org.jbpm.graph.node.Decision) {
			result = SimulationType.EXECUTE;
		} else {
			result = SimulationType.SKIP_NODE;
		}
		
		return result;
	}
	
	@SuppressWarnings({ "rawtypes" })
	protected NodeSimulationConfig getSimulationForNode(org.jbpm.graph.def.Node node, Map globalAttributes, Map<String, Map> attributesPerNode) {
		NodeSimulationConfig config = getNodeForSimulation(node.getName(), globalAttributes, attributesPerNode);
		if (config.getSimulationType() == null) {
			config.setSimulationType(getDefaultSimulationTypeForNode(node));
		}
		return config;
	}
	
	/**
	 * 		Gets the Nodes that can be simulated.
	 * 
	 * @param template
	 * @return
	 */
	@SuppressWarnings({ "rawtypes" })
	public Map<String, NodeSimulationConfig> getNodesForSimulation(ProcessDefinition template, Map globalAttributes) {
		Map<String, NodeSimulationConfig> simulationConfigMap = new HashMap<String, NodeSimulationConfig>();
		Map<String, Map> attributesPerNode = createSimulationDataMapPerNode(globalAttributes);
		List nodes = template.getNodes();
		for (Object nodeObj : nodes) {
			org.jbpm.graph.def.Node node = (org.jbpm.graph.def.Node) nodeObj;
			NodeSimulationConfig config = getSimulationForNode(node, globalAttributes, attributesPerNode);
			simulationConfigMap.put(node.getName(), config);
			
			if (node instanceof Loop) {
				Loop loop = (Loop) node;
				for (Object loopNode : loop.getNodes()) {
					org.jbpm.graph.def.Node innerLoopNode = (org.jbpm.graph.def.Node) loopNode;
					config = getSimulationForNode(innerLoopNode, globalAttributes, attributesPerNode);
					simulationConfigMap.put(innerLoopNode.getName(), config);
				}
			}
		}
		
		return simulationConfigMap;
	}
	
}
