/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.launching;

import com.tandbergtv.watchpoint.studio.debugger.WatchpointTemplateDebuggerPlugin;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlCustomVMDebugger;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.InterpreterWrapperServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.StandardVMDebugger;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.osgi.framework.Bundle;

public class TemplateLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object runner;
        int commandPort = -1;
        int eventPort = -1;
        if (mode.equals("debug")) {
            commandPort = TemplateLaunchConfigurationDelegate.findFreePort();
            eventPort = TemplateLaunchConfigurationDelegate.findFreePort();
        }
        if ((runner = this.getVMRunner(configuration, mode)) instanceof StandardVMDebugger) {
            runner = new JpdlCustomVMDebugger(this.verifyVMInstall(configuration), mode, commandPort, eventPort);
        }
        String workingPath = this.verifyWorkingDirectory(configuration) != null ? this.verifyWorkingDirectory(configuration).getAbsolutePath() : null;
        String[] env = this.getEnvironment(configuration);
        String pgmArgs = this.getTemplateSimulatorProgramArguments(configuration, commandPort, eventPort);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getTemplateSimulatorClasspath(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(InterpreterWrapperServer.class.getName(), classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setEnvironment(env);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingPath);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setBootClassPath(this.getBootpath(configuration));
        this.prepareStopInMain(configuration);
        runner.run(runConfig, launch, monitor);
    }

    private String getTemplateSimulatorProgramArguments(ILaunchConfiguration configuration, int commandPort, int eventPort) throws CoreException {
        StringBuilder arguments = new StringBuilder();
        String templateInWorkspace = configuration.getAttribute("com.tandberg.watchpoint.studio.template", "");
        IFile templateFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(templateInWorkspace));
        arguments.append(" --templateFile \"").append(templateFile.getParent().getFile((IPath)new Path("processdefinition.xml")).getLocation().toPortableString()).append("\"");
        arguments.append(" --presentationTemplateFile \"").append(templateFile.getLocation().toPortableString()).append("\"");
        arguments.append(" --configFile \"");
        if (configuration.getFile() != null) {
            arguments.append(configuration.getFile().getLocation().makeAbsolute().toPortableString());
        } else {
            arguments.append(configuration.getLocation().makeAbsolute().toPortableString());
        }
        arguments.append("\"");
        arguments.append(" --commandPort ").append(commandPort);
        arguments.append(" --eventPort ").append(eventPort);
        arguments.append(this.getProgramArguments(configuration));
        return arguments.toString();
    }

    private String[] getTemplateSimulatorClasspath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        Bundle bundle = WatchpointTemplateDebuggerPlugin.getDefault().getBundle();
        ArrayList<URL> libs = Collections.list(bundle.findEntries("lib/", "*.jar", true));
        try {
            classpath.add(this.getBundlePath(bundle, "/"));
            classpath.add(String.valueOf(this.getBundlePath(bundle, "/")) + "bin");
            for (URL url : libs) {
                String lib = url.getFile();
                classpath.add(this.getBundlePath(bundle, lib));
            }
            classpath.addAll(Arrays.asList(this.getClasspath(configuration)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classpath.toArray(new String[0]);
    }

    private String getBundlePath(Bundle bundle, String bundleEntry) throws IOException {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(bundleEntry), null);
        url = FileLocator.resolve((URL)url);
        return url.getFile();
    }

    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }
}

