package com.tandbergtv.watchpoint.studio.debugger.model;

import java.util.Map;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;

/**
 * 		Data persisted for Decision nodes.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class DecisionSimulationData extends SimulationData {

	public DecisionSimulationData(@SuppressWarnings("rawtypes") Map simulationAttributes) {
		super(simulationAttributes);
	}
	
	public DecisionSimulationData(SimulationData simulationData) {
		this(simulationData.simulationAttributes);
	}

	public void setFixedTransitionName(String fixedTransitionName) {
		setAttribute(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FIXED_TRANSITION, 
				     fixedTransitionName);
	}
	
	public String getFixedTransitionName() {
		return (String) getAttribute(TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FIXED_TRANSITION);
	}
}
