package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Transition;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class LoopNodeSimulator extends NodeSimulator {

	protected Transition toFirstNode = null;
	
	@Override
	public void simulate() {
		if (SimulationType.EXECUTE.equals(simulationConfig.getSimulationType())) {
			Loop2 loopNode = (Loop2) super.node;

			executionContext.setVariable(loopNode.getIndex(), loopNode.getInitialValue());
			
			boolean loop = loopNode.evaluateExpression(executionContext);
			if (loop) {
				toFirstNode = new Transition("start loop");
				toFirstNode.setFrom(loopNode);
				toFirstNode.setTo(loopNode.first());
			} 
		}
	}
	
	@Override
	public List<Transition> getLeavingTransitions() {
		Loop2 loopNode = (Loop2) super.node;
		
		boolean loop = false;
		if (!SimulationType.SKIP_NODE.equals(getSimulationConfig().getSimulationType())) {
			loop = loopNode.evaluateExpression(executionContext);
		}

		List<Transition> transitions = new ArrayList<Transition>();
		if (loop) {
			transitions.add(toFirstNode);
		} else {
			transitions.add(loopNode.getDefaultLeavingTransition());
		}
		
		return transitions;
	}

	@Override
	public boolean fail() {
		// Loop nodes doesn't fail
		return false;
	}
	
	@Override
	public Collection<VariableAccess> getVariables() {
		// Loop nodes doesn't affect variables 
		return Collections.emptyList();
	}

}
