package com.tandbergtv.watchpoint.studio.debugger.runtime.parser;

import static com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_DATA_TEMPLATE;
import static com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationConfigFactory.createFactory;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.jbpm.graph.def.ProcessDefinition;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;

public class RuntimeTemplateParser {
	
	public static Map<String, NodeSimulationConfig> parse(String file, ProcessDefinition template) throws Exception {
		LaunchConfigurationInfo info = parse(file);
		Map<String, NodeSimulationConfig> map = 
			createFactory().getNodesForSimulation(template, info.getAttributes());
		
		return map;
	}
	
	public static Map<String, NodeSimulationConfig> parse(File dir, ProcessDefinition template) {
		long time = 0L;
		LaunchConfigurationInfo launch = null;
		
		for (File file : getLaunchConfigurations(dir)) {
			LaunchConfigurationInfo info = parse(file.getAbsolutePath());
			String name = getTemplateName(info);
			
			if (!template.getName().equals(name))
				continue;
			
			if (file.lastModified() > time) {
				time = file.lastModified();
				launch = info;
			}
		}
		
		//FIXME Ideally we should terminate the launch
		if (launch == null)
			throw new RuntimeException("No launch configuration for template " + template.getName());
		
		return createFactory().getNodesForSimulation(template, launch.getAttributes());
	}
	
	private static List<File> getLaunchConfigurations(File dir) {
		File [] files = dir.listFiles(new FileFilter() {
			public boolean accept(File f) {
				return f.getName().endsWith("launch");
			}
		});
		
		return Arrays.asList(files);
	}
	
	private static LaunchConfigurationInfo parse(String name) {
		LaunchConfigurationInfo info = new LaunchConfigurationInfo();
		
		try {
			InputStream stream = new FileInputStream(new File(name));
			DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			
			parser.setErrorHandler(new DefaultHandler());
			
			Element root = parser.parse(new InputSource(stream)).getDocumentElement();
			
			
			info.initializeFromXML(root);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		
		return info;
	}
	
	private static String getTemplateName(LaunchConfigurationInfo info) {
		String string = info.getStringAttribute(TEMPLATE_LAUNCHER_PERSISTENT_DATA_TEMPLATE, null);
		
		if (string == null)
			return null;
		
		string = string.substring(string.lastIndexOf("/") + 1);
		
		return string.substring(0, string.indexOf("."));
	}
}
